#pragma once
#include "afxwin.h"

#include "ColorEdit.h"

#include "MyColorStaticST.h"

// OSD FONT STYLE (OSD PROPERTY)
//
enum {

    FONT_STYLE_REGULAR			= 0x00000000,
    
	FONT_STYLE_BOLD					= 0x00000001,
    
	FONT_STYLE_ITALIC				= 0x00000002,
    
	FONT_STYLE_BOLDITALIC		= 0x00000003,
    
	FONT_STYLE_UNDERLINE		= 0x00000004,
    
	FONT_STYLE_STRIKEOUT		= 0x00000008,
};

// CSetOSDText dialog

class CSetOSDText : public CDialogEx
{
	DECLARE_DYNAMIC(CSetOSDText)

public:
	CSetOSDText(CWnd* pParent = NULL);   // standard constructor
	virtual ~CSetOSDText();

// Dialog Data
	enum { IDD = IDD_SET_OSD_TEXT_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnBnClickedOk();
	afx_msg void OnBnClickedCancel();
	afx_msg void OnBnClickedBtnFontDlg();
	afx_msg void OnClickedScFontColor();
	afx_msg void OnClickedScBackgroundColor();
	afx_msg void OnClickedScBorderColor();
	afx_msg void OnSelchangeComboTextOsdFontSize();
	DECLARE_MESSAGE_MAP()

public:

	PVOID						m_pOSDAlphaBlender;

	int							m_nOSDLayer;
	
	int							m_nXOffset;

	int							m_nYOffset;

	int							m_nTextWidth;

	int							m_nTextHeight;

	int							m_nTransparent;

	int							m_nBorderWidth;

	int							m_nWeight;

	BYTE						m_bItalic;

	BYTE						m_bUnderline;

    BYTE						m_bStrikeOut;

	CString 					m_strTypeString;

	CString						m_strFontFamilyName;

	ULONG					m_nFontStyle;

	ULONG					m_nFontSize;

	COLORREF				m_clrFontColor;

	COLORREF				m_clrBackgroundColor;

	COLORREF				m_clrBorderColor;

	CComboBox			m_comboTextOSDLayer;

	CColorEdit				m_editTypeString;

	CComboBox			m_comboFontSize;		

	MyColorStaticST		m_scFontColor;

	MyColorStaticST		m_scBackgroundColor;

	MyColorStaticST		m_scBorderColor;	

	CFont *					m_pMyFont;
};
